/*
 * @(#)OMFactory.java  1.0  February 17, 2004
 *
 * Copyright (c) 2003 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.oo;

import ch.hslu.cm.oo.diagram.OMAssociationFigure;
import ch.hslu.cm.oo.diagram.OMClassFigure;
import ch.hslu.cm.oo.diagram.OMCommentLinkFigure;
import ch.hslu.cm.oo.diagram.OMDependencyFigure;
import ch.hslu.cm.oo.diagram.OMGeneralizationFigure;
import ch.hslu.cm.oo.diagram.OMLinkFigure;
import ch.hslu.cm.oo.diagram.OMMethodFigure;
import ch.hslu.cm.oo.diagram.OMObjectFigure;
import java.util.*;
import ch.hslu.cm.oo.objectmodel.*;
import ch.hslu.cm.oo.objectmodelbsh.*;
import ch.hslu.cm.simulation.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.ChopRectangleConnector;
import org.jhotdraw.draw.connector.StickyRectangleConnector;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.draw.locator.BezierLabelLocator;
import org.jhotdraw.xml.DefaultDOMFactory;
/**
 * OMFactory.
 * 
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 February 17, 2004 Created.
 */
public class OMFactory extends DefaultDOMFactory {
    private final static Object[][] classTagArray = {
        { ObjectModel.class, "objectmodel" },
        { OMAssociation.class, "association" },
        { OMAttribute.class, "attribute" },
        { OMDependency.class, "dependency" },
        { OMGeneralization.class, "generalization" },
        { OMLink.class, "link" },
        { OMOperation.class, "operation" },
        { OMClass.class, "class" },
        { OMObject.class, "object" },

        { ClassDiagram.class, "classdiagram" },
        { OMAssociationFigure.class, "associationF" },
        { OMClassFigure.class, "classF" },
        { OMDependencyFigure.class, "dependencyF" },
        { OMGeneralizationFigure.class, "generalizationF" },
        { OMLinkFigure.class, "linkF" },
        { OMObjectFigure.class, "objectF" },
        { TextFigure.class, "textF" },
        { OMMethodFigure.class, "methodF" },
        { OMCommentLinkFigure.class, "commentLinkF" },
        { GroupFigure.class, "g" },
        { TextAreaFigure.class, "ta" },
        
        { StickyRectangleConnector.class, "arectConnector" },
        { ChopRectangleConnector.class, "rectConnector" },
        { BezierLabelLocator.class, "polylabelLocator" },
        { ArrowTip.class, "arrowTip" }
    };
    
    /** Creates a new instance. */
    public OMFactory() {
        for (Object[] o : classTagArray) {
            addStorableClass((String) o[1], (Class) o[0]);
        }
    }
}
